// Nom du snack : eni_react_native_villes_liste
// Nom du script : App.js
// Auteur : Christian VIGOUROUX
// Date de création : 11/07/2024
// Date de dernière modification : 11/07/2024 (Christian VIGOUROUX)
// Objet : Affichage d'une liste de villes
//         avec une lecture depuis une table MySQL
// URL : https://snack.expo.dev/@cvigouroux/eni_react_native_villes_liste

// Import des composants React Native et React
import React, { useState, useEffect } from 'react';
import { SafeAreaView, Text, StyleSheet, View, FlatList } from 'react-native';

// Fonction principale App
export default function App() {

  // Constantes de la fonction App
  const [dataSource, setDataSource] = useState([]);

  // Méthode useEffect
  // NB : Accès aux données de l'application distante (format JSON)
  //      URL : http://christian-vigouroux.fr/react/php_mysql_liste_complete_villes.php
  useEffect(() => {
    fetch(
      'http://christian-vigouroux.fr/react/php_mysql_liste_complete_villes.php'
    )
      .then((response) => response.json())
      .then((responseJson) => {
        setDataSource(responseJson);
      })
      .catch((error) => {
        console.error(error);
      });
  }, []);

  // Valeur de retour de la fonction App
  return (
    
    // Vue de type SafeAreaView
    <SafeAreaView style={{ flex: 1 }}>
      
      {/* Vue d'affichage de la Flat List */}
      <View style={styles.container}>

        {/* Composant FlatList */}
        <FlatList
          data={dataSource}
          // keyExtractor={(item, index) => index.toString()}
          // Affichage de l'item
          renderItem={ItemView}
          // Affichage du trait de séparation
          ItemSeparatorComponent={ItemSeparatorView}
        />

      </View>

    </SafeAreaView>
  
  );

}

// Fonction ItemView
// NB : Définition de l'élément de la Flat List
const ItemView = ({ item }) => {
  
  // Valeur de retour de la fonction ItemView
  return (
    
    // Elément de la Flat List
    <Text
      // Style de l'élément
      style={styles.itemStyle}
    >
      {/* Affichage du champ id_Ville */}
      {item.id_ville}
      {/* Affichage d'un séparateur (tiret) */}
      {' - '}
      {/* Affichage du champ nom_ville */}
      {item.nom_ville}
    </Text>
  
  );

};

// Fonction ItemSeparatorView
// NB : Tracé d'une barre horizontale de séparation
const ItemSeparatorView = () => {
  
  // Valeur de retour de la fonction ItemSeparatorView
  return (
    
    // Trait de séparation
    <View
      // Style du trait
      style={{
        height: 5,
        width: '100%',
        backgroundColor: '#C8C8C8',
      }}
    />
  
  );
  
};

// Styles CSS
const styles = StyleSheet.create({
  container: {
    backgroundColor: 'white',
    flex: 1,
  },
  itemStyle: {
    padding: 10,
  },
});